<?php

# KONFIGUARTION EINBINDEN
include ("../inc/konfiguration.php");

# HEADER
header('Access-Control-Allow-Origin: *');
header('Content-type: application/json');

# MODUS
if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET["daten"])) {
	
	$modus = sicher($_GET["daten"]);
	
	if($modus == "hersteller") {

		$query = mysqli_query($con, "SELECT * FROM hersteller ORDER BY hersteller_name ASC") or die(mysqli_error($con));		
		$json_hersteller = array();
		
		if(mysqli_num_rows($query) == 0 ) {  
			
			$jsondata = array(
				'status' => '404',
				'nachricht' => 'Die API-Anfrage ergab keine Treffer.'				
			);
			
			echo json_encode($jsondata);
			
		}
		else {
					
			while($row = mysqli_fetch_array($query)) {
			
				$json_liste = array(
					'hersteller_id' => $row['hersteller_id'],
					'hersteller_name' => $row['hersteller_name']
				);

				$json_hersteller[] = $json_liste;
			
			}
			
			$jsondata = array(
				'hersteller' => $json_hersteller,
				'status' => '200',
				'nachricht' => 'Die API-Anfrage wurde erfolgreich aufgebaut.'
			);
			
			echo json_encode($jsondata);
			
		}
		
	}
	elseif($modus == "modelle" && isset($_GET["id"])) {
		
		$id = sicher($_GET["id"]);
		
		$query = mysqli_query($con, "SELECT * FROM modelle WHERE hersteller_id = ".$id." ORDER BY modell_name ASC") or die(mysqli_error($con));		
		$json_modelle = array();
		
		if(mysqli_num_rows($query) == 0 ) {  
			
			$jsondata = array(
				'status' => '404',
				'nachricht' => 'Die API-Anfrage ergab keine Treffer.'				
			);
			
			echo json_encode($jsondata);
			
		}
		else {
					
			while($row = mysqli_fetch_array($query)) {
			
				$json_liste = array(
					'hersteller_id' => $row['hersteller_id'],
					'hersteller_name' => $row['hersteller_id'],
					'modell_id' => $row['modell_id'],
					'modell_name' => $row['modell_name']
				);

				$json_modelle[] = $json_liste;
			
			}
			
			$jsondata = array(
				'modelle' => $json_modelle,
				'status' => '200',
				'nachricht' => 'Die API-Anfrage wurde erfolgreich aufgebaut.'
			);
			
			echo json_encode($jsondata);
			
		}
		
	}
	elseif($modus == "fahrzeuge" && isset($_GET["id"])) {
		
		$id = sicher($_GET["id"]);
		
		$query = mysqli_query($con, "SELECT * FROM fahrzeuge WHERE modell_id = ".$id." ORDER BY fahrzeug_name ASC") or die(mysqli_error($con));		
		$json_fahrzeuge = array();
		
		if(mysqli_num_rows($query) == 0 ) {  
			
			$jsondata = array(
				'status' => '404',
				'nachricht' => 'Die API-Anfrage ergab keine Treffer.'				
			);
			
			echo json_encode($jsondata);
			
		}
		else {
					
			while($row = mysqli_fetch_array($query)) {
				
				$fahrzeug_prod_monat_von = $row['fahrzeug_prod_monat_von'];
				if($fahrzeug_prod_monat_von == null) {
					$fahrzeug_prod_monat_von = "01";
				}
				else {
					$fahrzeug_prod_monat_von = sprintf("%02d", $fahrzeug_prod_monat_von);
				}
				
				$fahrzeug_prod_monat_bis = $row['fahrzeug_prod_monat_bis'];
				if($fahrzeug_prod_monat_bis == null) {
					$fahrzeug_prod_monat_bis = "12";
				}
				else {
					$fahrzeug_prod_monat_bis = sprintf("%02d", $fahrzeug_prod_monat_bis);
				}
			
				$json_liste = array(
					'hersteller_id' => $row['hersteller_id'],
					'hersteller_name' => $row['hersteller_name'],
					'modell_id' => $row['modell_id'],
					'modell_name' => $row['modell_name'],
					'fahrzeug_id' => $row['fahrzeug_id'],
					'fahrzeug_name' => $row['fahrzeug_name'],
					'fahrzeug_typ' => $row['fahrzeug_typ'],
					'fahrzeug_form' => $row['fahrzeug_form'],
					'fahrzeug_antriebsachse' => $row['fahrzeug_antriebsachse'],
					'fahrzeug_treibstoff' => $row['fahrzeug_treibstoff'],
					'fahrzeug_ps' => $row['fahrzeug_ps'],
					'fahrzeug_kw' => $row['fahrzeug_kw'],
					'fahrzeug_hubraum' => $row['fahrzeug_hubraum'],
					'fahrzeug_prod_monat_von' => $fahrzeug_prod_monat_von,
					'fahrzeug_prod_monat_bis' => $fahrzeug_prod_monat_bis,
					'fahrzeug_prod_jahr_von' => $row['fahrzeug_prod_jahr_von'],
					'fahrzeug_prod_jahr_bis' => $row['fahrzeug_prod_jahr_bis']
					
				);

				$json_fahrzeuge[] = $json_liste;
			
			}
			
			$jsondata = array(
				'fahrzeuge' => $json_fahrzeuge,
				'status' => '200',
				'nachricht' => 'Die API-Anfrage wurde erfolgreich aufgebaut.'
			);
			
			echo json_encode($jsondata);
		
		}
		
	}
	elseif($modus == "fahrzeugdaten" && isset($_GET["id"])) {
		
		$id = sicher($_GET["id"]);
				
		$query = mysqli_query($con, "SELECT * FROM fahrzeuge WHERE fahrzeug_id = ".$id."") or die(mysqli_error($con));		
		$json_fahrzeugdaten = array();
		
		if(mysqli_num_rows($query) == 0 ) {  
			
			$jsondata = array(
				'status' => '404',
				'nachricht' => 'Die API-Anfrage ergab keine Treffer.'				
			);
			
			echo json_encode($jsondata);
			
		}
		else {
			
			$row = mysqli_fetch_array($query);
			
			$fahrzeug_prod_monat_von = $row['fahrzeug_prod_monat_von'];
			if($fahrzeug_prod_monat_von == null) {
				$fahrzeug_prod_monat_von = "01";
			}
			else {
				$fahrzeug_prod_monat_von = sprintf("%02d", $fahrzeug_prod_monat_von);
			}
			
			$fahrzeug_prod_monat_bis = $row['fahrzeug_prod_monat_bis'];
			if($fahrzeug_prod_monat_bis == null) {
				$fahrzeug_prod_monat_bis = "12";
			}
			else {
				$fahrzeug_prod_monat_bis = sprintf("%02d", $fahrzeug_prod_monat_bis);
			}
			
			if($row['fahrzeug_motor_oelmenge'] == null) {
				$fahrzeug_motor_oelmenge = $row['fahrzeug_motor_oelmenge'];
			} else {
				$fahrzeug_motor_oelmenge = str_replace(".",",", $row['fahrzeug_motor_oelmenge']);
			}
			if($row['fahrzeug_schaltgetriebe_menge'] == null) {
				$fahrzeug_schaltgetriebe_menge = $row['fahrzeug_schaltgetriebe_menge'];
			} else {
				$fahrzeug_schaltgetriebe_menge = str_replace(".",",", $row['fahrzeug_schaltgetriebe_menge']);
			}
			if($row['fahrzeug_automatikgetriebe_menge'] == null) {
				$fahrzeug_automatikgetriebe_menge = $row['fahrzeug_automatikgetriebe_menge'];
			} else {
				$fahrzeug_automatikgetriebe_menge = str_replace(".",",", $row['fahrzeug_automatikgetriebe_menge']);
			}
			if($row['fahrzeug_bremsfluessigkeits_menge'] == null) {
				$fahrzeug_bremsfluessigkeits_menge = $row['fahrzeug_bremsfluessigkeits_menge'];
			} else {
				$fahrzeug_bremsfluessigkeits_menge = str_replace(".",",", $row['fahrzeug_bremsfluessigkeits_menge']);
			}
			if($row['fahrzeug_kuehlfluessigkeits_menge'] == null) {
				$fahrzeug_kuehlfluessigkeits_menge = $row['fahrzeug_kuehlfluessigkeits_menge'];
			} else {
				$fahrzeug_kuehlfluessigkeits_menge = str_replace(".",",", $row['fahrzeug_kuehlfluessigkeits_menge']);
			}
			
			$json_liste = array(
				'hersteller_id' => $row['hersteller_id'],
				'hersteller_name' => $row['hersteller_name'],
				'modell_id' => $row['modell_id'],
				'modell_name' => $row['modell_name'],
				'fahrzeug_id' => $row['fahrzeug_id'],
				'fahrzeug_name' => $row['fahrzeug_name'],
				'fahrzeug_typ' => $row['fahrzeug_typ'],
				'fahrzeug_form' => $row['fahrzeug_form'],
				'fahrzeug_eg_nummer' => $row['fahrzeug_eg_nummer'],
				'fahrzeug_antriebsachse' => $row['fahrzeug_antriebsachse'],
				'fahrzeug_achslast_va' => $row['fahrzeug_achslast_va'],
				'fahrzeug_achslast_ha' => $row['fahrzeug_achslast_ha'],
				'fahrzeug_zul_gesamtgewicht' => $row['fahrzeug_zul_gesamtgewicht'],
				'fahrzeug_laenge' => $row['fahrzeug_laenge'],
				'fahrzeug_breite' => $row['fahrzeug_breite'],
				'fahrzeug_hoehe' => $row['fahrzeug_hoehe'],
				'fahrzeug_stuetzlast' => $row['fahrzeug_stuetzlast'],
				'fahrzeug_anhaengelast_gebremst' => $row['fahrzeug_anhaengelast_gebremst'],
				'fahrzeug_anhaengelast_ungebremst' => $row['fahrzeug_anhaengelast_ungebremst'],
				'fahrzeug_treibstoff' => $row['fahrzeug_treibstoff'],
				'fahrzeug_motor' => $row['fahrzeug_motor'],
				'fahrzeug_motorcode' => $row['fahrzeug_motorcode'],
				'fahrzeug_motor_oelmenge' => $fahrzeug_motor_oelmenge,
				'fahrzeug_schaltgetriebecode' => $row['fahrzeug_schaltgetriebecode'],
				'fahrzeug_schaltgetriebe_menge' => $fahrzeug_schaltgetriebe_menge,
				'fahrzeug_automatikgetriebecode' => $row['fahrzeug_automatikgetriebecode'],
				'fahrzeug_automatikgetriebe_menge' => $fahrzeug_automatikgetriebe_menge,
				'fahrzeug_bremsfluessigkeits_menge' => $fahrzeug_bremsfluessigkeits_menge,
				'fahrzeug_kuehlfluessigkeits_menge' => $fahrzeug_kuehlfluessigkeits_menge,
				'fahrzeug_ps' => $row['fahrzeug_ps'],
				'fahrzeug_kw' => $row['fahrzeug_kw'],
				'fahrzeug_leistung_bei_umdrehungen' => $row['fahrzeug_leistung_bei_umdrehungen'],
				'fahrzeug_hubraum' => $row['fahrzeug_hubraum'],
				'fahrzeug_co2_emissions_wert' => $row['fahrzeug_co2_emissions_wert'],
				'fahrzeug_leergewicht' => $row['fahrzeug_leergewicht'],
				'fahrzeug_max_kmh' => $row['fahrzeug_max_kmh'],
				'fahrzeug_sitzanzahl' => $row['fahrzeug_sitzanzahl'],
				'fahrzeug_tueranzahl' => $row['fahrzeug_tueranzahl'],
				'fahrzeug_prod_monat_von' => $fahrzeug_prod_monat_von,
				'fahrzeug_prod_monat_bis' => $fahrzeug_prod_monat_bis,
				'fahrzeug_prod_jahr_von' => $row['fahrzeug_prod_jahr_von'],
				'fahrzeug_prod_jahr_bis' => $row['fahrzeug_prod_jahr_bis'],
				'fahrzeug_hsn' => $row['fahrzeug_hsn'],
				'fahrzeug_tsn' => $row['fahrzeug_tsn'],
				'fahrzeug_vsn' => $row['fahrzeug_vsn']
			);

			$json_fahrzeugdaten[] = $json_liste;
		
			$jsondata = array(
				'fahrzeugdaten' => $json_fahrzeugdaten,
				'status' => '200',
				'nachricht' => 'Die API-Anfrage wurde erfolgreich aufgebaut.'				
			);
			
			echo json_encode($jsondata);
			
		}
		
	}
	elseif($modus == "fahrzeugdaten" && isset($_GET["hsn"]) && isset($_GET["tsn"])) {
		
		$hsn = sicher($_GET["hsn"]);
		$tsn = sicher($_GET["tsn"]);
		
		$query = mysqli_query($con, "SELECT * FROM fahrzeuge WHERE LOWER(fahrzeug_hsn) = '".strtolower($hsn)."' AND LOWER(fahrzeug_tsn) = '".strtolower($tsn)."'") or die(mysqli_error($con));		
		$json_fahrzeugdaten = array();
		
		if(mysqli_num_rows($query) == 0 ) {  
			
			$jsondata = array(
				'status' => '404',
				'nachricht' => 'Die API-Anfrage ergab keine Treffer.'				
			);
			
			echo json_encode($jsondata);
			
		}
		else {
					
			$row = mysqli_fetch_array($query);
					
			$fahrzeug_prod_monat_von = $row['fahrzeug_prod_monat_von'];
			if($fahrzeug_prod_monat_von == null) {
				$fahrzeug_prod_monat_von = "01";
			}
			else {
				$fahrzeug_prod_monat_von = sprintf("%02d", $fahrzeug_prod_monat_von);
			}
			
			$fahrzeug_prod_monat_bis = $row['fahrzeug_prod_monat_bis'];
			if($fahrzeug_prod_monat_bis == null) {
				$fahrzeug_prod_monat_bis = "12";
			}
			else {
				$fahrzeug_prod_monat_bis = sprintf("%02d", $fahrzeug_prod_monat_bis);
			}
			
			if($row['fahrzeug_motor_oelmenge'] == null) {
				$fahrzeug_motor_oelmenge = $row['fahrzeug_motor_oelmenge'];
			} else {
				$fahrzeug_motor_oelmenge = str_replace(".",",", $row['fahrzeug_motor_oelmenge']);
			}
			if($row['fahrzeug_schaltgetriebe_menge'] == null) {
				$fahrzeug_schaltgetriebe_menge = $row['fahrzeug_schaltgetriebe_menge'];
			} else {
				$fahrzeug_schaltgetriebe_menge = str_replace(".",",", $row['fahrzeug_schaltgetriebe_menge']);
			}
			if($row['fahrzeug_automatikgetriebe_menge'] == null) {
				$fahrzeug_automatikgetriebe_menge = $row['fahrzeug_automatikgetriebe_menge'];
			} else {
				$fahrzeug_automatikgetriebe_menge = str_replace(".",",", $row['fahrzeug_automatikgetriebe_menge']);
			}
			if($row['fahrzeug_bremsfluessigkeits_menge'] == null) {
				$fahrzeug_bremsfluessigkeits_menge = $row['fahrzeug_bremsfluessigkeits_menge'];
			} else {
				$fahrzeug_bremsfluessigkeits_menge = str_replace(".",",", $row['fahrzeug_bremsfluessigkeits_menge']);
			}
			if($row['fahrzeug_kuehlfluessigkeits_menge'] == null) {
				$fahrzeug_kuehlfluessigkeits_menge = $row['fahrzeug_kuehlfluessigkeits_menge'];
			} else {
				$fahrzeug_kuehlfluessigkeits_menge = str_replace(".",",", $row['fahrzeug_kuehlfluessigkeits_menge']);
			}
			
			$json_liste = array(
				'hersteller_id' => $row['hersteller_id'],
				'hersteller_name' => $row['hersteller_name'],
				'modell_id' => $row['modell_id'],
				'modell_name' => $row['modell_name'],
				'fahrzeug_id' => $row['fahrzeug_id'],
				'fahrzeug_name' => $row['fahrzeug_name'],
				'fahrzeug_typ' => $row['fahrzeug_typ'],
				'fahrzeug_form' => $row['fahrzeug_form'],
				'fahrzeug_eg_nummer' => $row['fahrzeug_eg_nummer'],
				'fahrzeug_antriebsachse' => $row['fahrzeug_antriebsachse'],
				'fahrzeug_achslast_va' => $row['fahrzeug_achslast_va'],
				'fahrzeug_achslast_ha' => $row['fahrzeug_achslast_ha'],
				'fahrzeug_zul_gesamtgewicht' => $row['fahrzeug_zul_gesamtgewicht'],
				'fahrzeug_laenge' => $row['fahrzeug_laenge'],
				'fahrzeug_breite' => $row['fahrzeug_breite'],
				'fahrzeug_hoehe' => $row['fahrzeug_hoehe'],
				'fahrzeug_stuetzlast' => $row['fahrzeug_stuetzlast'],
				'fahrzeug_anhaengelast_gebremst' => $row['fahrzeug_anhaengelast_gebremst'],
				'fahrzeug_anhaengelast_ungebremst' => $row['fahrzeug_anhaengelast_ungebremst'],
				'fahrzeug_treibstoff' => $row['fahrzeug_treibstoff'],
				'fahrzeug_motor' => $row['fahrzeug_motor'],
				'fahrzeug_motorcode' => $row['fahrzeug_motorcode'],
				'fahrzeug_motor_oelmenge' => $fahrzeug_motor_oelmenge,
				'fahrzeug_schaltgetriebecode' => $row['fahrzeug_schaltgetriebecode'],
				'fahrzeug_schaltgetriebe_menge' => $fahrzeug_schaltgetriebe_menge,
				'fahrzeug_automatikgetriebecode' => $row['fahrzeug_automatikgetriebecode'],
				'fahrzeug_automatikgetriebe_menge' => $fahrzeug_automatikgetriebe_menge,
				'fahrzeug_bremsfluessigkeits_menge' => $fahrzeug_bremsfluessigkeits_menge,
				'fahrzeug_kuehlfluessigkeits_menge' => $fahrzeug_kuehlfluessigkeits_menge,
				'fahrzeug_ps' => $row['fahrzeug_ps'],
				'fahrzeug_kw' => $row['fahrzeug_kw'],
				'fahrzeug_leistung_bei_umdrehungen' => $row['fahrzeug_leistung_bei_umdrehungen'],
				'fahrzeug_hubraum' => $row['fahrzeug_hubraum'],
				'fahrzeug_co2_emissions_wert' => $row['fahrzeug_co2_emissions_wert'],
				'fahrzeug_leergewicht' => $row['fahrzeug_leergewicht'],
				'fahrzeug_max_kmh' => $row['fahrzeug_max_kmh'],
				'fahrzeug_sitzanzahl' => $row['fahrzeug_sitzanzahl'],
				'fahrzeug_tueranzahl' => $row['fahrzeug_tueranzahl'],
				'fahrzeug_prod_monat_von' => $fahrzeug_prod_monat_von,
				'fahrzeug_prod_monat_bis' => $fahrzeug_prod_monat_bis,
				'fahrzeug_prod_jahr_von' => $row['fahrzeug_prod_jahr_von'],
				'fahrzeug_prod_jahr_bis' => $row['fahrzeug_prod_jahr_bis'],
				'fahrzeug_hsn' => $row['fahrzeug_hsn'],
				'fahrzeug_tsn' => $row['fahrzeug_tsn'],
				'fahrzeug_vsn' => $row['fahrzeug_vsn']
			);

			$json_fahrzeugdaten[] = $json_liste;
		
			$jsondata = array(
				'fahrzeugdaten' => $json_fahrzeugdaten,
				'status' => '200',
				'nachricht' => 'Die API-Anfrage wurde erfolgreich aufgebaut.'				
			);
			
			echo json_encode($jsondata);
			
		}
		
	}
	else {
		
		$jsondata = array(
			'status' => '400',
			'nachricht' => 'Die API-Anfrage wurde fehlerhaft aufgebaut.'				
		);
		
		echo json_encode($jsondata);
		
	}
	
}
else {
		
	$jsondata = array(
		'status' => '400',
		'nachricht' => 'Die API-Anfrage wurde fehlerhaft aufgebaut.'				
	);
	
	echo json_encode($jsondata);
	
}

?>